# array.find()

These functions searches the array for the specified object.

```
array.find( value_or_closure=any )
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| value_or_closure | any | Yes | The value to find or a closure/function that gets every value of the array as input and returns true if the given value is right. *Alias: object, value, closure, function, udf, callback* |  |

# Examples

```cfml
	myarray = ["one","two","three","four","five"];
	writeDump(myarray);
	res = myarray.find("six");
	writeDump(res);
	res = myarray.find("one");
	writeDump(res);
```

# Categories

[Arrays](../../../categories/array.md), [Iterator](../../../categories/iterator.md)

# See Also

[ArrayFind()](../../functions/arrayfind.md), [Array](../array.md)