# array.filter()

This function creates a new Array that returns all the values from an array that match the given filter.

```
array.filter( filter=function, parallel=boolean, maxThreads=number )
```

**Returns:** array

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| filter | function | Yes | A function/closure that implements the following constructor `function(any arg){ return true/false;}` *Alias: closure, function, callback* |  |
| parallel | boolean | No | execute closures parallel |  |
| maxThreads | number | No | maximum number of threads executed, ignored when argument "parallel" is set to false *Alias: maxThreadCount* |  |

# Examples

```cfml
	fruitArray = [{fruit='apple', rating=4}, {fruit='banana', rating=1}, {fruit='orange', rating=5}, {fruit='mango', rating=2}, {fruit='kiwi', rating=3}];

	favoriteFruits = fruitArray.filter(function(item){
	    return item.rating >= 3;
	});
	dump(favoriteFruits);
```

# Categories

[Arrays](../../../categories/array.md), [Iterator](../../../categories/iterator.md), [Threads](../../../categories/thread.md)

# See Also

[ArrayFilter()](../../functions/arrayfilter.md), [Array](../array.md)