# array.every()

This function calls a given closure/function with every element in a given array and returns true, if all of the closure calls returns true.

```
array.every( closure=function, parallel=boolean, maxThreads=number )
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| closure | function | Yes | function/closure that implements the following constructor [function(any value[, numeric index,array array]):boolean]. *Alias: function, callback, udf* |  |
| parallel | boolean | No | execute closures parallel |  |
| maxThreads | number | No | maximum number of threads executed, ignored when argument "parallel" is set to false *Alias: maxThreadCount* |  |

# Examples

```cfml
	array = [ { name = "Frank", age = 40 }, { name = "Sue", age = 21 }, { name = "Jose", age = 54 } ];
	all_old = array.every(function(person) {
	    return person.age >= 40;
	},true,5);
	dump(all_old); // false
```

# Categories

[Arrays](../../../categories/array.md), [Iterator](../../../categories/iterator.md), [Threads](../../../categories/thread.md)

# See Also

[ArrayEvery()](../../functions/arrayevery.md), [Array](../array.md)