# array.each()

call the given UDF/Closure with every value in the array.

```
array.each( closure=function, parallel=boolean, maxThreads=number )
```

**Returns:** array

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| closure | function | Yes | A closure function (UDF) with the following signature: `function(el, idx, arr){}` Which is called for each item in the array. Where `el` is the element (or item) of the array, `idx` is the index position of that element, and `arr` is a reference to the base array upon which the array.Each function is called. *Alias: function, callback, udf* |  |
| parallel | boolean | No | execute closures parallel |  |
| maxThreads | number | No | maximum number of threads executed, ignored when argument "parallel" is set to false *Alias: maxThreadCount* |  |

# Examples

##### Basic Example

```cfml
aNames = array("Marcus", "Sarah", "Josefine");

aNames.each(
    function(element) {
        dump(element);
    }
);
```

##### Parallel Example with 3 Threads

```cfml
start = getTickCount();
a = ["a","b","c","d","e","f","g","h","i"];
a.each(function(element, index, array) {
    writeOutput("<code>#index#:#element# [#getTickCount()#]</code><br>");
    sleep(100);
}, true, 3);

writeOutput('Total Time: #(getTickCount()-start)# milliseconds<br>');
```

# Categories

[Arrays](../../../categories/array.md), [Iterator](../../../categories/iterator.md), [Threads](../../../categories/thread.md)

# See Also

[ArrayEach()](../../functions/arrayeach.md), [Array](../array.md)