# array.deleteAt()

Deletes an element from an array and resizes the array so that the deleted element doesn't leave a gap.

```
array.deleteAt( position=number )
```

**Returns:** array

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| position | number | Yes | The numeric position of the element. Remember that CFML arrays start at 1 not 0. *Alias: index* |  |

# Examples

```cfml
fruits = ["apple","orange","BANANA","banana","orange","Banana","Orange"];
writeDump(fruits.deleteat(3));
writeDump(fruits.deleteat(6));
```

# Categories

[Arrays](../../../categories/array.md)

# See Also

[ArrayDeleteAt()](../../functions/arraydeleteat.md), [Array](../array.md)