# array.containsNoCase()

Returns the position of the first element in the array whose string value contains the substring passed (not case sensitive), or 0 if no such element is found.

```
array.containsNoCase( needle=object, substringMatch=boolean )
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| needle | object | Yes | The substring to search for (not case sensitive) *Alias: value, object, obj, o* |  |
| substringMatch | boolean | No | If set to true then if a then a substring match will also return true. This will only work with simple values. Passing true with complex objects will throw an exception. |  |

# Examples

```cfml
fruits = ["apple","orange","BANANA","banana","orange","Banana","orange"];
writeDump(fruits.containsnocase("banana"));
```

# Categories

[Arrays](../../../categories/array.md)

# See Also

[ArrayContainsNoCase()](../../functions/arraycontainsnocase.md), [Array](../array.md)