# array.contains()

Returns the position of the first element in the array that matches the item that we are searching for, or 0 if the item is not found.

```
array.contains( needle=object, substringMatch=boolean )
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| needle | object | Yes | The item that we are looking for in the array *Alias: object, obj, o* |  |
| substringMatch | boolean | No | If set to true then if a then a substring match will also return true. This will only work with simple values. Passing true with complex objects will throw an exception. |  |

# Examples

```cfml
fruits = ["apple","orange","BANANA","banana","orange","Banana","Orange"];
writeDump(fruits.contains("banana"));
writeDump(fruits.contains("Orange"));
```

# Categories

[Arrays](../../../categories/array.md)

# See Also

[ArrayContains()](../../functions/arraycontains.md), [Array](../array.md)