# array.append()

Appends an array element to an array.

```
array.append( value=any, merge=boolean )
```

**Returns:** array

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| value | any | Yes | The element to append. Can be any type. *Alias: object, obj* |  |
| merge | boolean | No | This argument only applies when the value is an array. If set to true appends array elements individually to the source array. If false (default) the complete array is added as one element at the end, in the source array. |  |

# Examples

```cfml
	myarray = ["one","two","three","four","five"];
	writeDump(myarray);
	res = myarray.Append("six");
	writeDump(res);
```

# Categories

[Arrays](../../../categories/array.md)

# See Also

[ArrayAppend()](../../functions/arrayappend.md), [Array](../array.md)