# Array

Unlike some other languages, Arrays in CFML start at 1 rather than 0.

Arrays in Lucee are passed by reference, see [Migrating to Lucee from ColdFusion](../../guides/updating-lucee/migrate-from-acf.md)

- [array.append()](array/append.md) - Appends an array element to an array.
- [array.avg()](array/avg.md) - Calculates the average of the values in an array.
All elements in the array must contain values that can be automatically converted to numeric.
- [array.clear()](array/clear.md) - Removes all elements from an array.
- [array.contains()](array/contains.md) - Returns the position of the first element in the array that matches the item that we are searching for, or 0 if the item is not found.
- [array.containsNoCase()](array/containsnocase.md) - Returns the position of the first element in the array whose string value contains the substring passed (not case sensitive), or 0 if no such element is found.
- [array.delete()](array/delete.md) - Deletes specified object from given array
- [array.deleteAt()](array/deleteat.md) - Deletes an element from an array and resizes the array so that the deleted element doesn't leave a gap.
- [array.deleteNoCase()](array/deletenocase.md) - Deletes specified object from given array, in case of a string the case of the string does not matter.
- [array.each()](array/each.md) - call the given UDF/Closure with every value in the array.
- [array.every()](array/every.md) - This function calls a given closure/function with every element in a given array and returns true, if all of the closure calls returns true.
- [array.filter()](array/filter.md) - This function creates a new Array that returns all the values from an array that match the given filter.
- [array.find()](array/find.md) - These functions searches the array for the specified object.
- [array.findAll()](array/findall.md) - These functions searches the array for the specified object and return the positions of all occurrence of this values.
- [array.findAllNoCase()](array/findallnocase.md) - These functions searches the array for the specified object and return the positions of all occurrence of this values.
- [array.findNoCase()](array/findnocase.md) - These functions performs a case-insensitive search in the array for the specified object.
- [array.first()](array/first.md) - Returns the first item from an array. Throws an error if the array is empty.
- [array.indexExists()](array/indexexists.md) - Returns whether there exists an item in the array at the selected index.
- [array.insertAt()](array/insertat.md) - Inserts a value at the specified position in the array.
If the element is inserted before the end of the array, Lucee shifts the positions of all elements with a higher index to make room.
- [array.isDefined()](array/isdefined.md) - Returns whether there exists an item in the array at the selected index.
- [array.isEmpty()](array/isempty.md) - Determines if the array is empty.
- [array.last()](array/last.md) - Returns the last element of an array
- [array.len()](array/len.md) - Returns the length of a given array
- [array.map()](array/map.md) - Calls the given closure with every element in the given array.
the function returns an array that contains all values returned by the closure.
- [array.max()](array/max.md) - Returns the largest numeric value in an array. If the array
parameter value is an empty array, returns zero.
All elements must contain values that can be automatically
converted to numeric values.
- [array.median()](array/median.md) - Calculates the Median value of items in an array.
All elements in the array must contain values that can be converted to numeric.
- [array.merge()](array/merge.md) - This function creates a new array with data from the two passed arrays. To add all the data from one array into another without creating a new array see the built in function ArrayAppend(arr1, arr2, true).
- [array.mid()](array/mid.md) - Extracts a sub array from an array.
- [array.min()](array/min.md) - Returns the smallest numeric value in an array. If the array
parameter value is an empty array, returns zero.
All elements must contain values that can be automatically
converted to numeric values.
- [array.pop()](array/pop.md) - pops the last element from an array. In case the array is empty an exception is thrown, 
unless the second argument "defaultValue" is provided, in that case that value is returned.
- [array.prepend()](array/prepend.md) - Inserts an array element at the beginning of an array
and shifts the positions of the existing elements to
make room.
- [array.push()](array/push.md) - Inserts an array element at the end of an array and return the new size of the array.
- [array.reduce()](array/reduce.md) - Iterates over every entry of the given array and calls the closure with every element. 
This function will reduce the array to a single value and will return the value.
- [array.removeDuplicates()](array/removeduplicates.md) - Removes duplicate values from array.
- [array.resize()](array/resize.md) - Resets an array to a specified minimum number of elements.
This can improve performance, if used to size an array to its
expected maximum. For more than 500 elements, use ArrayResize
immediately after using the ArrayNew tag.
- [array.reverse()](array/reverse.md) - Returns a new array, with all the elements reversed
- [array.set()](array/set.md) - In a one-dimensional array, sets the elements in a specified
index range to a value. Useful for initializing an array after
a call to ArrayNew.
- [array.shift()](array/shift.md) - pops the first element from an array and shift the rest of the values to the left. In case the array is empty an exception is thrown, 
unless the second argument "defaultValue" is provided, in that case that value is returned.
- [array.slice()](array/slice.md) - Returns a new array, from the start position up to the count of elements
- [array.some()](array/some.md) - This function calls a given closure/function with every element in a given array and returns true, if one of the closure calls returns true.
- [array.sort()](array/sort.md) - Sorts array elements numerically or alphanumerically.
- [array.splice()](array/splice.md) - Modifies an array by removing elements and adding new elements. 
It starts from the index, removes as many elements as specified by elementCountForRemoval, 
and puts the replacements starting from index position.
Return the removed elements.
- [array.sum()](array/sum.md) - The sum of values in an array. If the array parameter value is
an empty array, returns zero.
- [array.swap()](array/swap.md) - Swaps array values of an array at specified positions. This
function is more efficient than multiple cfset tags
- [array.toList()](array/tolist.md) - Transform the array to a list of elements delimiter by the given string
- [array.toStruct()](array/tostruct.md) - Transform the array to a struct, by default, the index of the array is the key of the struct
- [array.unshift()](array/unshift.md) - Adds an element at the beginning of the array and shifts the rest of the elements to the right.

# Categories

[Arrays](../../categories/array.md), [Objects](../../categories/object.md)

# See Also

[ArrayNew()](../functions/arraynew.md)