# any.toJson()

Converts CFML data into a JSON (JavaScript Object Notation) representation of the data.

```
any.toJson( queryFormat=any, useSecureJSONPrefixOrCharset=any, compact=boolean )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| queryFormat | any | No | Either a Boolean value that specifies whether to serialize CFML queries by Column, or a string with the value "struct". *Alias: serializeQueryByColumns* |  |
| useSecureJSONPrefixOrCharset | any | No | string characters that cannot be encoded by this charset get escaped, if not set the web charset is used. *Alias: charset, charsetName, useSecureJSONPrefix* |  |
| compact | boolean | No | If true, it does not use end-of-lines and indentation. Defaults to true. |  |

# Examples

```cfml
	st = structNew();
	st.id = 1;
	st.Name = "Water";
	st.DESIGNATION = "Important source for all";
	st.data = [1,2,3,4,5];
	writeDump( st );

	jsonFormat = st.toJson();
	writeDump( jsonFormat );
```

# Categories

[Strings](../../../categories/string.md), [Formatting](../../../categories/formatting.md), [JSON](../../../categories/json.md), [JavaScript](../../../categories/javascript.md)

# See Also

[SerializeJSON()](../../functions/serializejson.md), [any](../any.md)