# any.numberFormat()

Creates a custom-formatted number value. For international
        number formatting use LSNumberFormat.
        [mask - quickly]
        _,9 Digit placeholder; . decimal point; 0 Pads with zeros;
        ( ) less than zero, puts parentheses around the mask
        + plus sign before positive number minus before negative
        - a space before positive minus sign before negative
        , Separates every third decimal place with a comma.
        L,C Left-justifies or center-justifies number
        $ dollar sign before formatted number.
        ^ Separates left and right formatting.

```
any.numberFormat( mask=string )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| mask | string | No | _ = optional digit . = decimal point 0 = mandatory digit |  |

# Examples

```cfml
	res = 123;
	writedump(res.numberFormat('__.00')); 
	writedump(res.numberFormat('99999'));
	writedump(res.numberFormat('99.99999'));
	writedump(res.numberFormat('_____'));
	writedump(res.numberFormat('+'));
	writedump(res.numberFormat('-'));
	writedump("1".numberFormat('C000'));
```

# Categories

[Numbers](../../../categories/number.md), [Strings](../../../categories/string.md), [Formatting](../../../categories/formatting.md)

# See Also

[NumberFormat()](../../functions/numberformat.md), [any](../any.md)