# XmlValidate()

Uses a Document Type Definition (DTD) or XML Schema to validate an XML text document or an XML document object.

```
XmlValidate( xmlDoc=string, validator=any );
```

**Returns:** struct

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| xmlDoc | string | Yes | The XML to validate *Alias: xml, xmlText, xmlString, xmlStr* |  |
| validator | any | No | Any of the following: - A string containing a DTD or Schema. - The name of a DTD or Schema file. - The URL of a DTD or Schema file; valid protocol identifiers include http, https, ftp, and file. *Alias: validators* |  |

# Examples

```cfml
  validator = "
		<?xml version=""1.0""?>
		<xs:schema xmlns:xs=""http://www.w3.org/2001/XMLSchema"">
			<xs:element name=""note"">
				<xs:complexType>
					<xs:sequence>
						<xs:element name=""to"" type=""xs:string""/>
						<xs:element name=""from"" type=""xs:string""/>
						<xs:element name=""heading"" type=""xs:string""/>
						<xs:element name=""body"" type=""xs:string""/>
					</xs:sequence>
				</xs:complexType>
			</xs:element>
		</xs:schema>
		";

		xml_stream = "
			<?xml version=""1.0"" encoding=""UTF-8""?>
			<note>
				<to>Alice</to>
				<from>Bob</from>
				<heading>Reminder</heading>
				<body>Here is the message you requested.</body>
			</note>";

		xml_document = XmlParse(xml_stream);
		dump(xmlValidate(xml_document, validator));
```







# Categories

[XML](../../categories/xml.md)