# XmlSearch()

Uses an XPath language expression to search an XML document object.

```
XmlSearch( xml=xml, xpath=string );
```

**Returns:** object

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| xml | xml | Yes | XML document object *Alias: xmlObj, xmlDoc, node* |  |
| xpath | string | Yes | XPath expression *Alias: path, xPathString* |  |

# Examples

```cfml
  xml_stream = '
			<?xml version="1.0" encoding="UTF-8"?>
			<notes>
				<note>
					<to>Alice</to>
					<from>Bob</from>
					<heading>Reminder</heading>
					<body>Here is the message you requested.</body>
				</note>
				<note>
					<to>Bob</to>
					<from>Alice</from>
					<heading>Your request</heading>
					<body>I got your message; all is well.</body>
				</note>
			</notes>';

		xml_document = XmlParse(xml_stream);

		dump(XmlSearch(xml_document,"/notes/note[last()]/body")); // I got your message; all is well.
```







# Categories

[XML](../../categories/xml.md)

# See Also

[HtmlParse()](htmlparse.md), [xml.search()](../objects/xml/search.md)