# XmlParse()

Converts an XML document that is represented as a string variable into an XML document object.

```
XmlParse( xmlString=string, caseSensitive=boolean, validator=any, lenient=boolean );
```

**Returns:** xml

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| xmlString | string | Yes | Any of the following: *Alias: xmlStr, xmlText, xml* |  |
| caseSensitive | boolean | No | Maintains the case of document elements and attributes. Default: false |  |
| validator | any | No | Any of the following: - A string containing a DTD or Schema - The name of a DTD or Schema file - The URL of a DTD or Schema file; valid protocol identifiers include http, https, ftp, and file - A struct of xmlFeatures directives - since 5.4.2.20 |  |
| lenient | boolean | No | if set to true, the parser is more lenient and forgives invalid XML and does the best to interpret it. | false |

# Examples

```cfml
  xml_stream = "
    <note>
      <to>Alice</to>
      <from>Bob</from>
      <heading>Reminder</heading>
      <body>Here is the message you requested.</body>
    </note>
  ";

  dump(XmlParse(xml_stream));
```




## Related System Properties / Environment Variables

- [LUCEE_XMLFEATURES_OVERRIDE_DISABLE](../environment-variables-system-properties.md#lucee_xmlfeatures_override_disable) - Boolean value to disable overriding XML parser features for security reasons
  ***Type:** boolean, **Default:** false*



# Categories

[Parsing](../../categories/parsing.md), [XML](../../categories/xml.md)

# See Also

[HtmlParse()](htmlparse.md), [Read XML with a listener Model (SAX)](../../recipes/read-xml-with-a-listener-model-sax.md), [XML Fast And Easy, using SAX - Listener Functions](../../recipes/xml-fast-and-easy.md)