# XmlGetNodeType()

Determines the type of an XML document object node.

```
XmlGetNodeType( xml=xml );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| xml | xml | Yes | An XML DOM object node *Alias: xmlDoc, xmlObj* |  |

# Examples

```cfml
  xml_stream = '
    <?xml version="1.0" encoding="UTF-8"?>
    <notes>
      <note>
        <to>Alice</to>
        <from>Bob</from>
        <heading>Reminder</heading>
        <body>Here is the message you requested.</body>
      </note>
      <note>
        <to>Bob</to>
        <from>Alice</from>
        <heading>Your request</heading>
        <body>I got your message; all is well.</body>
      </note>
    </notes>';

  xml_document = XmlParse(xml_stream);

  dump(XmlGetNodeType(xml_document.xmlRoot.XmlChildren[1].XmlChildren.last()));
```







# Categories

[XML](../../categories/xml.md)

# See Also

[xml.getNodeType()](../objects/xml/getnodetype.md)