# XmlElemNew()

Creates an XML document object element

```
XmlElemNew( xmlObj=xml, namespace_or_childName=string, childName=string );
```

**Returns:** org.w3c.dom.Element

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| xmlObj | xml | Yes | Name of the XML document object in which you are creating the element *Alias: xmlNode, node, element, xml, xmlDoc* |  |
| namespace_or_childName | string | No | URI of the namespace to which this element belongs or the name of the element to create. *Alias: namespace* |  |
| childName | string | No | The name of the element to create. This element becomes a child element of xmlObj in the tree. *Alias: name* |  |

# Examples

```cfml
  xml_document = XmlNew(); // new XML document to populate
  xml_root = XmlElemNew(xml_document,"notes");
  xml_document.XmlRoot = xml_root; // set the root node of the XML document

  xml_child = XmlElemNew(xml_document,"note"); // first child node

  xml_secondary_child = XmlElemNew(xml_document,"to"); // child node for the first child node
  xml_child.XmlChildren.append(xml_secondary_child);

  xml_root.XmlChildren.append(xml_child); // add the first child node to the XML document

  dump(xml_document);
```







# Categories

[XML](../../categories/xml.md)

# See Also

[xml.elemNew()](../objects/xml/elemnew.md)