# XmlChildPos()

Gets the position of a child element within an XML document object.

The position, in an XmlChildren array, of the Nth child that has the specified name.

```
XmlChildPos( node=xml, childName=string, index=number );
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| node | xml | Yes | XML element within which to search. *Alias: xmlNode, xmlObj, xmlDoc, xml* |  |
| childName | string | Yes | XML child element for which to search |  |
| index | number | Yes | Index of XML child element for which to search |  |

# Examples

```cfml
xml_stream = "
  <notes>
    <note>
      <to>Alice</to>
      <from>Bob</from>
      <heading>Reminder</heading>
      <body>Here is the message you requested.</body>
    </note>
    <author>
      <first>John</first>
      <last>Doe</last>
    </author>
  </notes>
";

xml_document = XmlParse(xml_stream);
xml_root = xml_document.XmlRoot;

dump(XmlChildPos(xml_root,"author",1)); // 2
```







# Categories

[XML](../../categories/xml.md)

# See Also

[xml.childPos()](../objects/xml/childpos.md)