# WriteOutput()

Writes the given string to the main response buffer regardless of
conditions established by the [<cfsetting>](../tags/setting.md) tag.

```
WriteOutput( string=string, encodeFor=string );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| string | string | Yes | A string to write to the buffer. |  |
| encodeFor | string | No | encode for what, valid values are: - css: for output inside Cascading Style Sheets (CSS) - dn: for output in LDAP Distinguished Names - html: for output inside HTML - html_attr: for output inside HTML Attributes - javascript: for output inside JavaScript - ldap: for output in LDAP queries - url: for output in URL - vbscript: for output inside vbscript - xml: for output inside XML - xml_attr: for output inside XML Attributes - xpath: for output in XPath |  |

# Examples

```cfml

html_paragraph = "<p>The Lucee project is led by the Lucee Association&nbsp;Switzerland a non-profit&nbsp;<a href=""https://en.wikipedia.org/wiki/Swiss_Verein"">swiss association</a>. A growing project which is committed to the success of its community by delivering quality software and a nurturing&nbsp;and supportive environment for developers to get involved.</p>";
writeOutput(html_paragraph);

```







# See Also

[Echo()](echo.md), [JSStringFormat()](jsstringformat.md), [SystemOutput()](systemoutput.md), [XmlFormat()](xmlformat.md), [<cfflush>](../tags/flush.md), [<cfhtmlbody>](../tags/htmlbody.md), [<cfhtmlhead>](../tags/htmlhead.md), [<cfoutput>](../tags/output.md), [<cfsetting>](../tags/setting.md)