# WriteLog()

Writes a message to a log file.

```
WriteLog( text=string, type=string, application=boolean, file=string, log=string );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| text | string | Yes | Message text to log. |  |
| type | string | No | Type (severity) of the message: - information (default) - warning - error - fatal |  |
| application | boolean | No | log application name, if it is specified in a cfapplication tag. |  |
| file | string | No | Message file. Specify only the main part of the filename. For example, to log to the Testing.log file, specify "Testing". The file must be located in the default log directory. You cannot specify a directory path. If the file does not exist, it is created automatically, with the suffix .log. |  |
| log | string | No | If you omit the file argument, writes messages to standard log file. Ignored, if you specify file argument. - application: writes to Application.log, normally used for application-specific messages. - scheduler: writes to Scheduler.log, normally used to log the execution of scheduled tasks. |  |

# Examples

```cfml
	writeLog(log="MyLog", text=now(), type="error");
```







# Categories

[Debugging](../../categories/debugging.md)

# See Also

[Console logging using SystemOutput](../../recipes/console-logging.md), [Logging](../../recipes/logging.md), [<cflog>](../tags/log.md)