# Wrap()

Wraps text so that each line has a specified maximum number of characters.

```
Wrap( string=string, limit=number, strip=boolean );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| string | string | Yes | The text to wrap. |  |
| limit | number | Yes | Positive integer maximum number of characters to allow on a line. |  |
| strip | boolean | No | Whether to remove all existing newline and carriage return characters in the input string with spaces before wrapping the text. |  |

# Examples

```cfml
long_string = "A light-weight dynamic scripting language for the JVM that enables the rapid development of simple to highly sophisticated web applications.";
echo( "<pre>" & wrap( long_string, 20 ) & "</pre>" );
```







# Categories

[Strings](../../categories/string.md)

# See Also

[string.wrap()](../objects/string/wrap.md)