# ValueList()

Returns a list of all the values, for a given column within the query, delimited by the value given.

It is recommended to use [QueryColumnData()](querycolumndata.md) instead.

**Status:** deprecated

```
ValueList( query_column=queryColumn, delimiter=string );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| query_column | queryColumn | Yes | Name of an executed query and column. Separate query name and column name with a period. *Alias: queryColumn* |  |
| delimiter | string | No | A delimiter character to separate column data items. Default: comma (,). *Alias: delimiters* | , |

# Examples

```cfml
test_query = queryNew("name , age" , "varchar , numeric", { name: [ "John Doe" , "Jane Doe", "Frank Jones" ] , age: [ 20 , 24, 33 ] });
dump(ValueList(test_query.name, "; "));
```







# Categories

[Queries](../../categories/query.md)

# See Also

[QueryColumnData()](querycolumndata.md)