# Val()

Converts numeric characters that occur at the beginning of a string to a number by stripping off all remaining characters once a non-numeric character is reached.

If the string does not start with any numeric characters or is empty, a 0 is returned. A period will be included, so val() will return a decimal.

```
Val( value=string );
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| value | string | Yes | A string or a variable that contains one *Alias: string* |  |

# Examples

```cfml
    dump(Val("1234 Main St.")); // 1234
    dump(Val("Main St., 1234")); // 0
    dump(Val("123.456")); // 123.456
    dump(Val("")); // 0
    dump(Val("1")); // 1
    dump(Val("one")); // 0
    dump(Val("123T456")); // 123
```







# Categories

[Numbers](../../categories/number.md), [Parsing](../../categories/parsing.md)

# See Also

[Int()](int.md), [ParseNumber()](parsenumber.md), [ToNumeric()](tonumeric.md)