# URLEncodedFormat()

Generates an URL-encoded string.

For example, it replaces spaces with %20, and non-alphanumeric characters with equivalent
hexadecimal escape sequences. Passes arbitrary strings within a URL.

```
URLEncodedFormat( string=string, charset=string, force=boolean );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| string | string | Yes | A string or a variable that contains one |  |
| charset | string | No | The character encoding in which the string is encoded. | utf-8 |
| force | boolean | No | If false, then the string will not be encoded if it does not contain unsafe characters. | true |

# Examples

```cfml
url_string = "https://dev.lucee.org/t/welcome-to-lucee-dev/2064";
dump(URLEncodedFormat(url_string)); // https%3A%2F%2Fdev%2Elucee%2Eorg%2Ft%2Fwelcome%2Dto%2Dlucee%2Ddev%2F2064
```







# Categories

[Strings](../../categories/string.md), [Formatting](../../categories/formatting.md), [Encode/Decode](../../categories/esapi.md)

# See Also

[URLEncode()](urlencode.md), [string.uRLEncodedFormat()](../objects/string/urlencodedformat.md)