# URLEncode()

encode an url

```
URLEncode( string=string, charset=string, force=boolean );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| string | string | Yes | String to encode |  |
| charset | string | No | The World Wide Web Consortium Recommendation states that UTF-8 should be used as per <https://www.w3.org/TR/html40/appendix/notes.html#non-ascii-chars> - Using different charsets may cause incompatibilities with other systems. | utf-8 |
| force | boolean | No | If false, then the string will not be encoded if it does not contain unsafe characters. | true |

# Usage Notes

With Lucee 6.1, the underlying encoder was switched to Use Apache Common Codec, which is stricter but more standards compliant

# Examples

```cfml
url_string = "https://dev.lucee.org/t/welcome-to-lucee-dev/2064";
dump(URLEncode(url_string)); // https%3A%2F%2Fdev%2Elucee%2Eorg%2Ft%2Fwelcome%2Dto%2Dlucee%2Ddev%2F2064
```







# Categories

[Encode/Decode](../../categories/esapi.md)

# See Also

[URLDecode()](urldecode.md), [URLEncodedFormat()](urlencodedformat.md), [string.URLEncode()](../objects/string/urlencode.md)