# URLDecode()

Decodes an URL-encoded string.

```
URLDecode( string=string, charset=string, strict=boolean );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| string | string | Yes | URL-encoded string. |  |
| charset | string | No | The character encoding in which the string is encoded. | utf-8 |
| strict | boolean | No | Default *true*, uses the Apache Commons UrlDecoder which has better overall support for UTF-8 etc, but throws an exception on invalid encodings. When **false**, it will attempt strict mode first, then fall back to the older custom implementation which strips out invalid encodings, if strict fails. |  |

# Usage Notes

With Lucee 6.1, the underlying decoder was switched to use Apache Common Codec, which is stricter but more standards compliant.

Use the `strict=false` argument for the older behaviour, which strips out invalid encodings and doesn't throw an exception.

By default, Lucee attempts to decode all values passed in the `url` and `form` scopes, using strict mode. If an decoding error occurs, Lucee passes the raw value thru.

# Examples

```cfml
encoded_string = "https%3A%2F%2Fdev%2Elucee%2Eorg%2Ft%2Fwelcome%2Dto%2Dlucee%2Ddev%2F2064";
dump(URLDecode(encoded_string)); // https://dev.lucee.org/t/welcome-to-lucee-dev/2064
```







# Categories

[Encode/Decode](../../categories/esapi.md)

# See Also

[URLEncode()](urlencode.md), [string.uRLDecode()](../objects/string/urldecode.md)