# UcFirst()

Capitalizes the first character of the given string.

```
UcFirst( string=string, doAll=boolean, doLowerIfAllUppercase=boolean );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| string | string | Yes | the input string |  |
| doAll | boolean | No | If true, then every word is capitalized, where a new word is defined as alpha characters that come after whitespace, a dot [.], a dash [-], or (parenthesis). This is especially useful to clean up user input of names, e.g. converting a string like "susi q. sorgolis" to "Susi Q. Sorgolis" |  |
| doLowerIfAllUppercase | boolean | No | If true, then if the input string contains letters and they are all UPPERCASE, then the input string is first lowercased. When combined with the doAll argument, this is especially useful to clean user input of names when they are all UPPERCASE, e.g. converting "SUSI Q. SORGOLIS" to "Susi Q. Sorgolis" while preserving the CaSe if the input is e.g. "Ronald McDonald" |  |

# Examples

```cfml
string = "submitting bugs and feature requests via our online system";

dump(UcFirst(string, false, false));
dump(UcFirst(string, true, false));
```







# Categories

[Strings](../../categories/string.md)

# See Also

[string.ucFirst()](../objects/string/ucfirst.md)