# Trace()

Displays and logs debugging data about the state of an application at the time this function executes.

Tracks runtime logic flow, variable values, and execution time.

Displays output at the end of the request or in the debugging section at the end of the request.

```
Trace( var=string, text=string, type=string, category=string, inline=boolean, abort=boolean, follow=boolean );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| var | string | No | The name of a simple or complex variable to display. Useful for displaying a temporary value, or a value that does not display on any CFM page. |  |
| text | string | No | string, which can include simple variable, but not complex variables such as arrays. |  |
| type | string | No | Corresponds to the cflog type attribute: - Information - Warning - Error - Fatal Information |  |
| category | string | No | string name for identifying trace groups |  |
| inline | boolean | No | if true displays trace code in line on the page in the location of the trace function, addition to the debugging information output. |  |
| abort | boolean | No | stops further processing of the request. |  |
| follow | boolean | No | If true, Lucee follows the variable defined in the [var] attribute and will log any changes to it. Ignored when attribute [var] is not defined. |  |

# Examples

*There are currently no examples for this function*







# Categories

[Debugging](../../categories/debugging.md)

# See Also

[<cftrace>](../tags/trace.md)