# ToString()

Converts a value to a string.

```
ToString( value=any, encoding=string );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| value | any | No | Value to convert to a string; can be a simple value such as an integer, a binary object, an XML document object, or a Java InputStream. |  |
| encoding | string | No | The character encoding (character set) of the string. |  |

# Examples

### Function example

```cfml
writeDump(toString(45));
dt=now();
writeDump(toString(dt));
```

### Member function example

```cfml
number=randrange(1,10);
writeDump(number.toString());
dt=now();
writeDump(dt.toString());

```







# Categories

[Strings](../../categories/string.md)

# See Also

[Int()](int.md)