# ToScript()

Creates a JavaScript expression that assigns the value of a variable to a JavaScript variable.

This function can convert strings, numbers, arrays, structures, and queries to JavaScript syntax that defines equivalent variables and values.

This function always forces keys to lowercase, in both ACF and Lucee, as such it's recommended to use [SerializeJSON()](serializejson.md) instead.

```
ToScript( cfvar=any, javascriptVar=string, outputFormat=boolean, ASFormat=boolean );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| cfvar | any | Yes | A variable. |  |
| javascriptVar | string | Yes | A string that specifies the name of the JavaScript variable that the ToScript function creates. |  |
| outputFormat | boolean | No | A Boolean value that determines whether to create WDDX (JavaScript) or ActionScript style output for structures and queries. Default: true | true |
| ASFormat | boolean | No | A Boolean value that specifies whether to use ActionScript shortcuts in the script. Default: false |  |

# Examples

```cfml
  // Struct
  Struct = {};
  Struct[1] = "lucee";
  jsVar = serializeJson(Struct);
  resStruct = ToScript(struct, "jsVar");
  writeDump(resStruct);
   
  // Array
  Array = [];
  Array[1] = "lucee";
  jsVar = serializeJson(Array);
  resArr = ToScript(Array, "jsVar");
  writeDump(resArr);

  // Query
  Query = queryNew( "name,age", "varchar,numeric", {name = "Susi", age = 20 } );
  resQry = ToScript(Query, "Query");
  writeDump(resQry);

  // String
  Str = "test";
  resStr = ToScript(Str, "Str");
  writeDump(resStr);

  // Number
  number = 10;
  resNum = ToScript(number, "number");
  writeDump(resNum);
```







# Categories

[Strings](../../categories/string.md), [JavaScript](../../categories/javascript.md)

# See Also

[SerializeJSON()](serializejson.md)