# ToBinary()

Calculates the binary representation of Base64-encoded data.

```
ToBinary( data=any, charset=string );
```

**Returns:** binary

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| data | any | Yes | A variable representing data in Base64-encoded format or a PDF document. |  |
| charset | string | No | if first argument is a string and this argument is set, the string is not handled as base64 encoded string, it is simply converted to a binary, with help of the given argument. the value can be a valid charset name, "web" for the web charset defined with this context or "resource" for the resource charset defined in the context. |  |

# Examples

```cfml
base_64 = ToBase64("I am a string.");
dump(ToBinary(base_64));
```







# Categories

[Encode/Decode](../../categories/esapi.md), [Binary data](../../categories/binary.md)

# See Also

[ToBase64()](tobase64.md)