# ToBase64()

Calculates the Base64 representation of a string or binary object.

The Base64 format uses printable characters, allowing
binary data to be sent in forms and e-mail, and stored in a
database or file.

```
ToBase64( strOrBin=any, encoding=string );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| strOrBin | any | Yes | A string, the name of a string, or a binary object. *Alias: string, BinaryData* |  |
| encoding | string | No | For a string, defines how characters are represented in a byte array. |  |

# Examples

```cfml
dump(ToBase64("ToBase64")); // VG9CYXNlNjQ=
```







# Categories

[Encode/Decode](../../categories/esapi.md), [Binary data](../../categories/binary.md)

# See Also

[ImageReadBase64()](imagereadbase64.md), [ImageWriteBase64()](imagewritebase64.md), [ToBinary()](tobinary.md), [string.toBase64()](../objects/string/tobase64.md)