# TimeFormat()

Formats a time object to a given string output.

```
TimeFormat( time=any, mask=string, timezone=timezone );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| time | any | Yes | date object; for example, [now()](now.md) |  |
| mask | string | No | Formatting mask for time: - h: hours; no leading zero for single-digit hours (12-hour clock) - hh: hours; leading zero for single-digit hours (12-hour clock) - H: hours; no leading zero for single-digit hours (24-hour clock) - HH: hours; leading zero for single-digit hours (24-hour clock) - m: minutes; no leading zero for single-digit minutes - mm: minutes; a leading zero for single-digit minutes - s: seconds; no leading zero for single-digit seconds - ss: seconds; leading zero for single-digit seconds - l or L: milliseconds, with no leading zeros - t: one-character time marker string, such as A or P - tt: multiple-character time marker string, such as AM or PM The following masks are options to format the full time and cannot be combined with other masks: - short: equivalent to h:mm tt - medium: equivalent to h:mm:ss tt - long: equivalent to h:mm:ss tt {timezone-3-letters} - full: equivalent to h:mm:ss tt {timezone-3-letters} | hh:mm tt |
| timezone | timezone | No | A datetime object is independent of a specific timezone; it is only an offset in milliseconds from `1970-1-1 00.00:00 UTC` (Coordinated Universal Time). The timezone only comes into play when you need specific information like hours in a day, minutes in a hour or which day it is as these calculations depend on the timezone. A timezone must be specified in order to translate the date object to something else. If you do not provide the timezone in the function call, it will default to the timezone specified in the Lucee Administrator (Settings/Regional), or the timezone specified for the current request using the function [setTimezone()](settimezone.md). You can find a list of all available timezones in the Lucee administrator (Settings/Regional). Some examples of valid timezones include: - AGT (for time in Argentina) - Europe/Zurich (for time in Zurich/Switzerland) - HST (Hawaiian Standard Time in the USA) - JVM (JVM / Server Default Timezone) |  |

# Examples

```cfml

//simple Function
writeDump(TimeFormat(CreateDateTime( 2009, 6, 29, 24, 0, 0),"h TT"));//12 AM

//Member function
dt=CreateDateTime(2018,07,04,13,12,12);
writeDump(dt.TimeFormat("hh:mm:ss"));//01:12:12

```







# Categories

[Date and time](../../categories/datetime.md), [Strings](../../categories/string.md), [Formatting](../../categories/formatting.md)

# See Also

[LSTimeFormat()](lstimeformat.md), [datetime.timeFormat()](../objects/datetime/timeformat.md)