# Throw()

Throws a developer-specified exception, which can be caught with a [<cfcatch>](../tags/catch.md) tag

```
Throw( message=string, type=string, detail=string, errorcode=string, extendedInfo=string, object=any, cause=any );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| message | string | No | Message that describes exception event. |  |
| type | string | No | - A custom type - Application Do not enter another predefined type; types are not generated by CFML applications. If you specify Application, you need not specify a type for cfcatch. |  |
| detail | string | No | Additional detail about the exception. Often used for more sensitive information, i.e. which you may choose not to display to end users |  |
| errorcode | string | No | A custom error code that you supply. |  |
| extendedInfo | string | No | Extended information about the exception. |  |
| object | any | No | Throws a Java exception from a CFML tag. This attribute is mutually exclusive with all other arguments of this function. |  |
| cause | any | No | The cause of the exception created with this tag. This can be a cfcatch block or a native java exception. |  |

# Examples

```cfml
    // thrown as a statement example
	try {
		throw "thrown";
	} catch (e){
		dump(var=cfcatch, label="single argument keyword");
	}

    /* this won't work as expected, because thrown expects only a single
        argument function in cfscript, only message will be populated
     see https://luceeserver.atlassian.net/browse/LDEV-2832
    */
	try {
		throw message="thrown"
			detail="deets"
			errorCode="403"
			type="Test";
	} catch (e){
		dump(var=cfcatch, label="additional arguments are ignored");
	}

	// use this syntax instead
	try {
		throw (message="thrown",
			detail="deets",
			errorCode="403",
			type="Test");
	} catch (e){
		dump(var=cfcatch, label="script throw with arguments");
	}
```







# See Also

[<cfthrow>](../tags/throw.md)