# StructUpdate()

Updates a key with a value.

```
StructUpdate( struct=struct, key=string, value=any );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| struct | struct | Yes | Structure to update *Alias: structure, object* |  |
| key | string | Yes | Key, the value of which to update |  |
| value | any | Yes | New value |  |

# Examples

### Non-Member Function

```cfml
animals = {
	cow: "moo",
	pig: "oink",
	cat: "meow"
};

// Show current animals
Dump(
	label: "Current animals",
	var: animals
);

// Update cat in animals
StructUpdate(animals, "cat", "purr");

// Show animals with updated cat in animals
Dump(
	label: "Animals with cat updated",
	var: animals
);
```







# Categories

[Structures](../../categories/struct.md)

# See Also

[struct.update()](../objects/struct/update.md)