# StructSort()

Returns a sorted array of the top level keys in a structure.

Sorts using alphabetic or numeric sorting, and can sort based on the values of any structure element.

```
StructSort( base=struct, sortTypeOrSortFunc=any, sortOrder=string, pathToSubElement=string );
```

**Returns:** array

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| base | struct | Yes | A structure with one field (an associative array). |  |
| sortTypeOrSortFunc | any | No | Define one of the following: - numeric: sorts numbers - text: sorts text alphabetically, taking case into account (case sensitive) - textNoCase: sorts text alphabetically, without regard to case (case insensitive) or a function to be used as a comparator (introduced 6.2.1) `function(value1, value2, key1, key2)` *Alias: sortType* | text |
| sortOrder | string | No | sort direction: - asc (default): ascending (a to z) sort order - desc: descending (z to a) sort order | asc |
| pathToSubElement | string | No | String or a variable that contains one *Alias: path* |  |

# Examples

### Non-Member Function

```cfml
animals = {
	cow: {
		total: 12
	},
	pig: {
		total: 5
	},
	cat: {
		total: 3
	}
};

// Show current animals
Dump(
	label: "Current animals",
	var: animals
);

// Show animals sorted by total
Dump(
	label: "Animals sorted by total",
	var: StructSort(animals, "numeric", "asc", "total")
);
```

### Example using callback (Introduced in 6.2.1.29)

```cfml
  myStruct={a="London",b="Paris",c="Berlin",d="New York",e="Dublin"};
  	// define callaback function
    function callback(e1, e2){
    	return compare(arguments.e1, arguments.e2);
    }
	writeDump(var=myStruct,label="Before sorting")
    writeDump(var=StructSort(myStruct,callback),label="After sorting");
```




## Related System Properties / Environment Variables

- [LUCEE_SECURITY_LIMITEVALUATION](../environment-variables-system-properties.md#lucee_security_limitevaluation) - Disable evaluating expressions when accessing scopes, Lucee 7 defaults to enabling this setting for security reasons. A boolean value. If enabled, limits variable evaluation in functions/tags. If enabled, you cannot use expressions within [ ] like this: susi[getVariableName()]. This affects the following functions: IsDefined, structGet, structSort (when using pathToSubElement), empty and the following tags: savecontent attribute `variable`
  ***Type:** boolean, **Default:** false (Lucee 6), true (Lucee 7)*



# Categories

[Structures](../../categories/struct.md), [Sorting](../../categories/sort.md)

# See Also

[struct.sort()](../objects/struct/sort.md)