# StructSome()

This function calls a closure/function on every element in a struct until one returns true.

If one of the closure calls it will return returns true, otherwise false

```
StructSome( struct=struct, closure=function, parallel=boolean, maxThreads=number );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| struct | struct | Yes | struct to iterate *Alias: structure, object* |  |
| closure | function | Yes | function/closure that implements the following constructor `function(key, value, st){}` and returns a boolean value *Alias: function, callback, udf* |  |
| parallel | boolean | No | execute closures parallel |  |
| maxThreads | number | No | maximum number of threads executed, ignored when argument "parallel" is set to false *Alias: maxThreadCount* | 20 |

# Examples

```cfml
st = {
	1 : { active: true},
	2 : { active: false},
	3 : { active: false}
};

result = structSome(st, function(key,value){
	dump(var=value, label=key);
	return value.active;
});
dump (result);
```







# Categories

[Collections](../../categories/collection.md), [Structures](../../categories/struct.md)

# See Also

[struct.some()](../objects/struct/some.md)