# StructReduce()

Iterates over every entry of the given struct and calls the closure with every key/value.

This function will reduce the struct to a single value and will return this value.

```
StructReduce( struct=struct, closure=function, initialValue=object );
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| struct | struct | Yes | struct to iterate *Alias: structure, object* |  |
| closure | function | Yes | function/closure that implements the following constructor `function(result, key, value, st) { return result; }` *Alias: function, callback, udf* |  |
| initialValue | object | No | initial value passed as part of the first closure call *Alias: initial, initalValue* |  |

# Examples

### Non-Member Function

```cfml
animals = {
	cow: {noise: "moo",  size: "large"},
	pig: {noise: "oink", size: "medium"},
	cat: { noise: "meow", size: "small"}
};
dump(label: "All animals", var: animals);

animalInfo = StructReduce(animals, function(result, key, value) {
	return arguments.result & "<li>" & arguments.key & "<ul><li>Noise: " & arguments.value.noise & "</li><li>Size: " & arguments.value.size & "</li></ul></li>";
}, "<ul>") & "</ul>";

// Show result
echo(animalInfo);
```







# Categories

[Collections](../../categories/collection.md), [Structures](../../categories/struct.md)

# See Also

[struct.reduce()](../objects/struct/reduce.md)