# StructNew()

Creates an empty structure.

The shorthand syntax for structNew is ` {}; `

The shorthand syntax to create an ordered structure is ` [:]; ` or ` [=]; `

You can also create structures with data using this syntax:

- a normal structure ` { "key": value }; `
- a linked/ordered structure use ` [ "key": value ]; `

To preserve the case of the struct key, use a quoted value for the key, otherwise, it will be converted to uppercase.

Support for shorthand notation was introduced with Lucee 6.1

```
lucee = "rocks";
ralio = "rocked";
st = { lucee, ralio };  // produces { "RALIO":"rocked","LUCEE":"rocks" }
```

```
StructNew( type=string, onMissingKey=function );
```

**Returns:** struct

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| type | string | No | the type of structure created: - **normal** (default): a regular struct ( thread safe ) - **ordered**: a struct with linked or ordered keys that maintain their insertion order ( alias **linked** ) - **soft**: a struct with soft reference values, which are cleared at the discretion of the garbage collector in response to memory demand. - **weak**: a struct containing weakly referenced values, which do not prevent their referents from being garbage collected. Weak references are most often used to implement simple caches. _Note, the older type "synchronized" is now same as the default, **normal**; all struct/scopes are "thread safe" since version 4.1._ | normal |
| onMissingKey | function | No | listener function that get invoked in case a request key does not exist. |  |

# Examples

**Lucee Script**

```cfml
dump(var=structNew("soft"), label="soft");
dump(var=structNew("weak"), label="weak");
dump(var=structNew("linked"), label="linked");

st = {
    "one": [1,2,3],
    "two": {
        "three": QueryNew("id")
    },
    three: "unquoted keys don't preserve case"
};

dump( st );
dump( structKeyList(st) );
dump( structKeyExists(st, "one") );

// shorthand syntax for a new empty ordered struct, [=] also works
st = [:];
st.c = 1;
st.b = 2;
st.a = 3;
dump(st);

// shorthand syntax for an ordered struct with values
st = [
    c: 1,
    b: 2,
    a: 3
];
dump(st);
```

**Lucee Tags**

```cfml
<cfset st = structNew()>

<cfset st["name"] = "John Doe">
<cfset st["age"] = 30>
<cfset st["city"] = "New York">

<cfdump var="#st#">
```







# Categories

[Collections](../../categories/collection.md), [Structures](../../categories/struct.md)

# See Also

[ArrayNew()](arraynew.md), [Struct](../objects/struct.md)