# StructMap()

Calls the given closure with every element in the given struct.
the function returns a struct that contains all values returned by the closure.

```
StructMap( struct=struct, closure=function, parallel=boolean, maxThreads=number );
```

**Returns:** struct

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| struct | struct | Yes | struct to iterate *Alias: structure* |  |
| closure | function | Yes | filter can be a function/closure that implements the following constructor [function(string key, any value[, struct struct]):any]. *Alias: function, callback, udf* |  |
| parallel | boolean | No | execute closures parallel |  |
| maxThreads | number | No | maximum number of threads executed, ignored when argument "parallel" is set to false *Alias: maxThreadCount* | 20 |

# Examples

### structmap examples

```cfml

	sct=structNew("linked");
		sct.a=1;
		sct.b=2;
		sct.c=3;
	writedump(var=sct, label="original struct");

	// base test
	res=StructMap(sct, function(key, value ){
 						return key&":"&value;
                        },true);
	writedump(var=res, label="mapped struct");
```







# Categories

[Collections](../../categories/collection.md), [Structures](../../categories/struct.md), [Threads](../../categories/thread.md)

# See Also

[struct.map()](../objects/struct/map.md)