# StructKeyTranslate()

Converts any struct keys with dot notation into nested structures

```
StructKeyTranslate( struct=struct, deepTranslation=boolean, leaveOriginalKey=boolean );
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| struct | struct | Yes | Structure to translate *Alias: structure, object* |  |
| deepTranslation | boolean | No | also translate keys of child structures |  |
| leaveOriginalKey | boolean | No | leave original key in struct |  |

# Examples

### Non-Member Function

```cfml
animals = {
	cow: {
	    noise: "moo",
	    size: "large"
	},
	"bird.noise": "chirp",
	"bird.size": "small"
};

// Show all animals
Dump(
	label: "All animals",
	var: animals
);

// Call function
StructKeyTranslate(animals);

// Show all animals after keyTranslate
Dump(
	label: "All animals after keyTranslate",
	var: animals
);
```







# Categories

[Structures](../../categories/struct.md)

# See Also

[struct.keyTranslate()](../objects/struct/keytranslate.md)