# StructKeyList()

Extracts keys from a struct.

```
StructKeyList( struct=struct, delimiter=string );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| struct | struct | Yes | Structure from which to extract a list of keys. *Alias: structure, object* |  |
| delimiter | string | No | String that separates keys in list. Default: comma. *Alias: delimiters* | , |

# Usage Notes

For unsorted structs, Adobe returns a text sorted list of keys, for performance reasons, Lucee simply returns the raw sort order

# Examples

### Non-Member Function

```cfml
animals = {
	cow: "moo",
	pig: "oink",
	cat: "meow",
	bird: "chirp"
};

// StructKeyList(animals)
animalList = StructKeyList(animals);

echo(animalList);
```







# Categories

[Structures](../../categories/struct.md)

# See Also

[StructKeyArray()](structkeyarray.md), [struct.keyList()](../objects/struct/keylist.md)