# StructKeyExists()

Determines whether a specific key is present in a structure.

```
StructKeyExists( struct=struct, key=string );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| struct | struct | Yes | Name of structure to test *Alias: structure, object* |  |
| key | string | Yes | Key to test |  |

# Usage Notes

Using this function to check if a session variable exists, will create a session, if it doesn't already exist.

With Lucee 6.2, we have introduced [SessionExists()](sessionexists.md) which can be safely used to check if a session has been created

# Examples

### Non-Member Function

```cfml
animals = {
	cow: "moo",
	pig: "oink",
	cat: "meow",
	bird: "chirp"
};

// Check to see if key exists in struct
if (
	StructKeyExists(animals, "snail")
) {
	echo("There is a snail in 'animals'");
} else {
	echo("No snail exists in 'animals'");
}
```







# Categories

[Structures](../../categories/struct.md)

# See Also

[IsDefined()](isdefined.md), [IsNull()](isnull.md), [SessionExists()](sessionexists.md), [struct.keyExists()](../objects/struct/keyexists.md)