# StructKeyArray()

Returns an array of the keys from a structure; if structure does not exist, CFML throws an exception.

```
StructKeyArray( struct=struct );
```

**Returns:** array

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| struct | struct | Yes | Structure from which to extract a list of keys *Alias: structure, object* |  |

# Usage Notes

For unsorted structs, Adobe returns a text sorted Array of keys, for performance reasons, Lucee simply returns the raw sort order

# Examples

### Unordered Structs (default)

```cfml
animals = {
	cow: "moo",
	pig: "oink",
	cat: "meow",
	bird: "chirp"
};
dump(StructKeyArray(animals));
```

### Ordered Structs

```cfml
animals = [
	cow: "moo",
	pig: "oink",
	cat: "meow",
	bird: "chirp"
];
dump(StructKeyArray(animals));
```







# Categories

[Structures](../../categories/struct.md)

# See Also

[StructKeyList()](structkeylist.md), [struct.keyArray()](../objects/struct/keyarray.md)