# StructIsEmpty()

Determines whether a structure contains data.

```
StructIsEmpty( struct=struct );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| struct | struct | Yes | Structure to test *Alias: structure, object* |  |

# Examples

### Non-Member Function

```cfml
// Non empty struct
animals = {
	cow: "moo",
	pig: "oink"
};

// Empty struct
farm = {};

// StructIsEmpty(animals)
echo("<p>Animals struct is empty: " & StructIsEmpty(animals) & "</p>");

// StructIsEmpty(farm)
echo("<p>Farm struct is empty: " & StructIsEmpty(farm) & "</p>");
```







# Categories

[Structures](../../categories/struct.md), [Decision logic](../../categories/decision.md)

# See Also

[struct.isEmpty()](../objects/struct/isempty.md)