# StructInsert()

Inserts a key-value pair into a structure.

```
StructInsert( struct=struct, key=string, value=any, allowOverwrite=boolean );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| struct | struct | Yes | Structure to contain the new key-value pair. *Alias: structure, object* |  |
| key | string | Yes | Key that contains the inserted value. |  |
| value | any | Yes | Value to add. |  |
| allowOverwrite | boolean | No | Whether to allow overwriting a key. Default: False. *Alias: overwrite* |  |

# Examples

### Non-Member Function

```cfml
animals = {
	cow: "moo",
	pig: "oink"
};

// Show current animals
Dump(
	label: "Current animals",
	var: animals
);

// Insert cat into animals
StructInsert(animals, "cat", "meow");

// Show animals, now includes cat
Dump(
	label: "Animals with cat added",
	var: animals
);
```







# Categories

[Structures](../../categories/struct.md), [Collections](../../categories/collection.md)

# See Also

[struct.insert()](../objects/struct/insert.md)