# StructGet()

Gets a structure(s) from a specified path.

```
StructGet( PathDesired=string );
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| PathDesired | string | Yes | Pathname of variable that contains structure or array from which Lucee retrieves structure. *Alias: path* |  |

# Examples

```cfml
animals = {
	cat: {
		activities: {
		    sleep: true,
		    eat: true,
		    drink: true
		}
	}
};

// Show all animals
Dump(
	label: "All animals",
	var: animals
);

// Get cat activities in animals
getCatActivities = StructGet("animals.cat.activities");

// Show results of getCatActivities
Dump(
	label: "Results of StructGet(""animals.cat.activities"")",
	var: getCatActivities
);

// If the path does not exist, result returns an empty structure.
findDog = StructGet("animals.dog");

// Show results of findDog
Dump(
	label: "Results of StructGet(""animals.dog"")",
	var: findDog
);
```




## Related System Properties / Environment Variables

- [LUCEE_SECURITY_LIMITEVALUATION](../environment-variables-system-properties.md#lucee_security_limitevaluation) - Disable evaluating expressions when accessing scopes, Lucee 7 defaults to enabling this setting for security reasons. A boolean value. If enabled, limits variable evaluation in functions/tags. If enabled, you cannot use expressions within [ ] like this: susi[getVariableName()]. This affects the following functions: IsDefined, structGet, structSort (when using pathToSubElement), empty and the following tags: savecontent attribute `variable`
  ***Type:** boolean, **Default:** false (Lucee 6), true (Lucee 7)*



# Categories

[Structures](../../categories/struct.md)