# StructFindValue()

Searches recursively through a substructure of nested arrays,
structures, and other elements for structures with values that
match the search key in the value parameter.

```
StructFindValue( Top=struct, Key=string, Scope=string );
```

**Returns:** array

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| Top | struct | Yes | structure from which to start search. This parameter requires an object, not a name of an object. |  |
| Key | string | Yes | Value for which to search |  |
| Scope | string | No | - one (default): function returns one matching key - all: function returns all matching keys | one |

# Examples

### Non-Member Function

```cfml
animals = {
	cow: {
		noise: "moo",
		size: "large"
	},
	pig: {
		noise: "oink",
		size: "medium"
	},
	cat: {
		noise: "meow",
		size: "small"
	}
};

// Show all animals
Dump(
	label: "All animals",
	var: animals
);

// Find animal containing value of 'medium'
findMediumAnimal = StructFindValue(animals, "medium");

// Show results in findMediumAnimal
Dump(
	label: "Results of StructFindValue(animals, ""medium"")",
	var: findMediumAnimal
);
```







# Categories

[Structures](../../categories/struct.md)

# See Also

[struct.findValue()](../objects/struct/findvalue.md)