# StructFindKey()

Searches recursively through a substructure of nested arrays,
structures, and other elements, for structures whose values
match the search key in the value parameter.

```
StructFindKey( Top=struct, Key=string, Scope=string );
```

**Returns:** array

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| Top | struct | Yes | object from which to start search. This parameter requires an object, not a name of an object. *Alias: struct* |  |
| Key | string | Yes | Key for which to search. |  |
| Scope | string | No | - one (default): returns one matching key. - all: returns all matching keys | one |

# Examples

### Non-Member Function

```cfml
animals = {
	cow: {
		noise: "moo",
		size: "large"
	},
	pig: {
		noise: "oink"
	},
	cat: {
		noise: "meow",
		size: "small"
	}
};

// Show all animals
Dump(
	label: "All animals",
	var: animals
);

// Find "all" animal(s) containing key of 'size'
findAnimalsWithSize = StructFindKey(animals, "size", "all");

// Show results in findAnimalsWithSize
Dump(
	label: "Results of StructFindKey(animals, ""size"", ""all"")",
	var: findAnimalsWithSize
);
```







# Categories

[Structures](../../categories/struct.md)

# See Also

[struct.findKey()](../objects/struct/findkey.md)