# StructFind()

Determines the value associated with a key in a structure.

```
StructFind( struct=struct, key=string, defaultValue=any );
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| struct | struct | Yes | Structure that contains the value to return *Alias: structure, object* |  |
| key | string | Yes | Key whose value to return |  |
| defaultValue | any | No | Default value which will be returned if the key does not exist or if null was found |  |

# Examples

### Non-Member Function

```cfml
animals = {
	cow: "moo",
	pig: "oink",
	cat: "meow"
};

// Show all animals
Dump(
	label: "All animals",
	var: animals
);

// Find cat in animals
findCat = StructFind(animals, "cat");

// Show results of findCat
Dump(
	label: "Results of StructFind(animals, ""cat"")",
	var: findCat
);

// If the key does not exist, we can set a default value. In this case a blank string.
findSnail = StructFind(animals, "snail", "");

// Show results of findSnail
Dump(
	label: "Results of StructFind(animals, ""snail"", """")",
	var: findSnail
);
```







# Categories

[Structures](../../categories/struct.md)

# See Also

[struct.find()](../objects/struct/find.md)