# StructEvery()

This function calls a given closure/function with every element in a given struct and returns true, if all of the closure calls returns true.

```
StructEvery( struct=struct, closure=function, parallel=boolean, maxThreads=number );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| struct | struct | Yes | struct to iterate *Alias: structure, object* |  |
| closure | function | Yes | function/closure that implements the following constructor `function(key, value, st){}` and returns a boolean value *Alias: function, callback, udf* |  |
| parallel | boolean | No | execute closures parallel |  |
| maxThreads | number | No | maximum number of threads executed, ignored when argument "parallel" is set to false *Alias: maxThreadCount* | 20 |

# Examples

### Non-Member Function

```cfml
animals = {
	cow: "moo",
	pig: "oink",
	cat: "meow"
};

// Use StructEvery() to iterate over keys in struct. Closure returns true/false.
allAnimalsAreNoisy = StructEvery(animals, function(key) {
	// If the key has a value return true (noisy animal)
	if (Len(animals[arguments.key])) {
		return true;
	}

	return false;
});

Dump(
	label: "allAnimalsAreNoisy",
	var: allAnimalsAreNoisy
);

// Use StructEvery() to iterate over keys in struct. Closure returns true/false.
allAnimalsAreQuiet = StructEvery(animals, function(key) {
	// If the key is blank return true (quiet animal)
	if (! Len(animals[arguments.key])) {
		return true;
	}

	return false;
});

Dump(
	label: "allAnimalsAreQuiet",
	var: allAnimalsAreQuiet
);
```







# Categories

[Collections](../../categories/collection.md), [Structures](../../categories/struct.md), [Threads](../../categories/thread.md)

# See Also

[struct.every()](../objects/struct/every.md)